---@meta

---@class ASliceAndDiceManager : AActor
---@field Mappings TArray<USliceAndDiceMapping>
local ASliceAndDiceManager = {}

---@param bInLoggingEnabled boolean
---@param InLogPath FString
function ASliceAndDiceManager:SetLogging(bInLoggingEnabled, InLogPath) end
---@param SelectedMappings TArray<USliceAndDiceMapping>
---@return boolean
function ASliceAndDiceManager:RunRulesOnMappings(SelectedMappings) end
---@return boolean
function ASliceAndDiceManager:RunRules() end
---@param SelectedMappings TArray<USliceAndDiceMapping>
---@param Level EPointCloudReportLevel
---@return FString
function ASliceAndDiceManager:RunReportOnMappings(SelectedMappings, Level) end
---@param Level EPointCloudReportLevel
---@return FString
function ASliceAndDiceManager:RunReport(Level) end
---@param InMapping USliceAndDiceMapping
---@param bDeleteManagedActors boolean
---@return boolean
function ASliceAndDiceManager:RemoveMapping(InMapping, bDeleteManagedActors) end
---@param SelectedMappings TArray<USliceAndDiceMapping>
---@return boolean
function ASliceAndDiceManager:ReloadPointCloudsOnMappings(SelectedMappings) end
---@return boolean
function ASliceAndDiceManager:ReloadAllPointClouds() end
---@return int32
function ASliceAndDiceManager:NumMappings() end
---@param InMapping TArray<USliceAndDiceMapping>
---@param InTargetManager ASliceAndDiceManager
---@return boolean
function ASliceAndDiceManager:MoveMappings(InMapping, InTargetManager) end
---@param InMapping USliceAndDiceMapping
---@param InTargetManager ASliceAndDiceManager
---@return boolean
function ASliceAndDiceManager:MoveMapping(InMapping, InTargetManager) end
---@param InLevel ULevel
---@return TArray<ASliceAndDiceManager>
function ASliceAndDiceManager:GetSliceAndDiceManagersInLevel(InLevel) end
---@param InWorld UWorld
---@return TArray<ASliceAndDiceManager>
function ASliceAndDiceManager:GetSliceAndDiceManagers(InWorld) end
---@param InPointCloud UPointCloud
---@param InRuleSet UPointCloudSliceAndDiceRuleSet
---@return USliceAndDiceMapping
function ASliceAndDiceManager:FindOrAddMapping(InPointCloud, InRuleSet) end
---@param InPointCloud UPointCloud
---@param InRuleSet UPointCloudSliceAndDiceRuleSet
---@return USliceAndDiceMapping
function ASliceAndDiceManager:FindMapping(InPointCloud, InRuleSet) end
---@param InMappings TArray<USliceAndDiceMapping>
---@param bCleanDisabled boolean
---@return boolean
function ASliceAndDiceManager:DeleteManagedActorsFromMappings(InMappings, bCleanDisabled) end
---@param InMapping USliceAndDiceMapping
---@param bCleanDisabled boolean
---@return boolean
function ASliceAndDiceManager:DeleteManagedActorsFromMapping(InMapping, bCleanDisabled) end
---@param bCleanDisabled boolean
---@return boolean
function ASliceAndDiceManager:DeleteAllManagedActors(bCleanDisabled) end
---@param InWorld UWorld
---@return ASliceAndDiceManager
function ASliceAndDiceManager:CreateSliceAndDiceManager(InWorld) end
---@return USliceAndDiceMapping
function ASliceAndDiceManager:AddNewMapping() end


---@class FCustomOverrides
---@field StructClass UScriptStruct
---@field StructInstance FInstancedStruct
local FCustomOverrides = {}



---@class FPointCloudPoint
---@field Transform FTransform
---@field Attributes TMap<FString, FString>
local FPointCloudPoint = {}



---@class FPointCloudRuleData
---@field World UWorld
---@field CustomOverrides FCustomOverrides
---@field OverrideableProperties TArray<FName>
---@field OverridenProperties TArray<FName>
local FPointCloudRuleData = {}



---@class FSliceAndDiceActorMapping
---@field Actors TArray<TSoftObjectPtr<AActor>>
---@field ActorHandles TArray<FActorInstanceHandle>
---@field Statements TArray<FString>
local FSliceAndDiceActorMapping = {}



---@class FSliceAndDiceManagedActorsEntry
---@field ParentHash FString
---@field Hash FString
---@field ActorMappings TArray<FSliceAndDiceActorMapping>
local FSliceAndDiceManagedActorsEntry = {}



---@class FSliceAndDiceManagedActorsHashInfo
---@field Hash FString
---@field ParentHash FString
---@field ActorIndex uint32
---@field ActorCount uint32
local FSliceAndDiceManagedActorsHashInfo = {}



---@class UPointCloud : UObject
---@field RootViews TSet<UPointCloudView>
local UPointCloud = {}

---@return boolean
function UPointCloud:StopLogging() end
---@param InFilename FString
---@return boolean
function UPointCloud:StartLogging(InFilename) end
---@param Filename FString
---@return boolean
function UPointCloud:SaveToDisk(Filename) end
---@param Filename FString
---@param ReimportBounds FBox
---@return boolean
function UPointCloud:ReplacePoints(Filename, ReimportBounds) end
---@param ReimportBounds FBox
---@return boolean
function UPointCloud:Reimport(ReimportBounds) end
---@return UPointCloudView
function UPointCloud:MakeView() end
---@return boolean
function UPointCloud:LoggingEnabled() end
---@param InPoints TArray<FPointCloudPoint>
---@return boolean
function UPointCloud:LoadFromPoints(InPoints) end
---@param Name FString
---@return boolean
function UPointCloud:HasMetaDataAttribute(Name) end
---@param Name FString
---@return boolean
function UPointCloud:HasDefaultAttribute(Name) end
---@return TSet<FString>
function UPointCloud:GetMetadataAttributes() end
---@return TArray<FString>
function UPointCloud:GetLoadedFiles() end
---@return TArray<FString>
function UPointCloud:GetDefaultAttributes() end
---@return int32
function UPointCloud:GetCount() end
---@return FBox
function UPointCloud:GetBounds() end


---@class UPointCloudImpl : UPointCloud
local UPointCloudImpl = {}


---@class UPointCloudRule : UObject
---@field Label FString
---@field Color FColor
---@field bEnabled boolean
---@field bAlwaysReRun boolean
---@field Slots TArray<UPointCloudRule>
---@field SlotInfo TArray<UPointCloudRuleSlot>
---@field RevisionNumber uint64
local UPointCloudRule = {}



---@class UPointCloudRuleSlot : UObject
---@field Label FString
---@field bExternallyVisible boolean
---@field Guid FGuid
local UPointCloudRuleSlot = {}



---@class UPointCloudSliceAndDiceRuleSet : UObject
---@field Rules TArray<UPointCloudRule>
local UPointCloudSliceAndDiceRuleSet = {}

---@param InRuleParent UPointCloudRule
---@param InRuleSlotIndex int32
---@param InTargetParent UPointCloudRule
---@param InTargetSlotIndex int32
---@return boolean
function UPointCloudSliceAndDiceRuleSet:SwapRules(InRuleParent, InRuleSlotIndex, InTargetParent, InTargetSlotIndex) end
---@param InParent UPointCloudRule
---@param InSlotIndex int32
---@return UPointCloudRule
function UPointCloudSliceAndDiceRuleSet:RemoveRule(InParent, InSlotIndex) end
---@param InRuleParent UPointCloudRule
---@param InRuleSlotIndex int32
---@param InTargetParent UPointCloudRule
---@param InTargetSlotIndex int32
---@return boolean
function UPointCloudSliceAndDiceRuleSet:MoveRule(InRuleParent, InRuleSlotIndex, InTargetParent, InTargetSlotIndex) end
---@return TArray<UPointCloudRule>
function UPointCloudSliceAndDiceRuleSet:GetRules() end
---@param RuleName FString
---@param ParentRule UPointCloudRule
---@param SlotIndex int32
---@return UPointCloudRule
function UPointCloudSliceAndDiceRuleSet:CreateRule(RuleName, ParentRule, SlotIndex) end
---@param InRule UPointCloudRule
---@param InTargetParent UPointCloudRule
---@param InTargetSlotIndex int32
---@return boolean
function UPointCloudSliceAndDiceRuleSet:CopyRule(InRule, InTargetParent, InTargetSlotIndex) end
---@param InRule UPointCloudRule
---@param InParent UPointCloudRule
---@param InSlotIndex int32
---@return boolean
function UPointCloudSliceAndDiceRuleSet:AddRule(InRule, InParent, InSlotIndex) end


---@class UPointCloudView : UObject
---@field ViewGuid FGuid
---@field PointCloud UPointCloudImpl
---@field ParentView UPointCloudView
---@field ChildViews TSet<UPointCloudView>
local UPointCloudView = {}

---@return UPointCloudView
function UPointCloudView:MakeChildView() end
---@param Key FString
---@return TMap<FString, int32>
function UPointCloudView:GetUniqueMetadataValuesAndCounts(Key) end
---@param Key FString
---@return TArray<FString>
function UPointCloudView:GetUniqueMetadataValues(Key) end
---@param OutTransforms TArray<FTransform>
---@param OutIds TArray<int32>
---@return int32
function UPointCloudView:GetTransformsAndIds(OutTransforms, OutIds) end
---@return TArray<FTransform>
function UPointCloudView:GetTransforms() end
---@return FBox
function UPointCloudView:GetResultsBoundingBox() end
---@return UPointCloud
function UPointCloudView:GetPointCloud() end
---@param Key FString
---@return TArray<int32>
function UPointCloudView:GetMetadataValuesArrayAsInt(Key) end
---@param Key FString
---@return TArray<float>
function UPointCloudView:GetMetadataValuesArrayAsFloat(Key) end
---@param Key FString
---@return TMap<int32, FString>
function UPointCloudView:GetMetadataValues(Key) end
---@param POINTID int32
---@return TMap<FString, FString>
function UPointCloudView:GetMetadata(POINTID) end
---@param OutIds TArray<int32>
---@return int32
function UPointCloudView:GetIndexes(OutIds) end
---@return FString
function UPointCloudView:GetHash() end
---@return int32
function UPointCloudView:GetCount() end
---@param QueryGridBounds FBox
---@param InNumTilesX int32
---@param InNumTilesY int32
---@param InNumTilesZ int32
---@param InTileX int32
---@param InTileY int32
---@param InTileZ int32
---@param bInvertSelection boolean
---@param Mode EFilterMode
function UPointCloudView:FilterOnTile(QueryGridBounds, InNumTilesX, InNumTilesY, InNumTilesZ, InTileX, InTileY, InTileZ, bInvertSelection, Mode) end
---@param StartIndex int32
---@param EndIndex int32
---@param Mode EFilterMode
function UPointCloudView:FilterOnRange(StartIndex, EndIndex, Mode) end
---@param Expression FString
---@param Mode EFilterMode
function UPointCloudView:FilterOnPointExpression(Expression, Mode) end
---@param InOBB FTransform
---@param bInvertSelection boolean
---@param Mode EFilterMode
function UPointCloudView:FilterOnOrientedBoundingBox(InOBB, bInvertSelection, Mode) end
---@param MetaData FString
---@param Pattern FString
---@param Mode EFilterMode
function UPointCloudView:FilterOnMetadataPattern(MetaData, Pattern, Mode) end
---@param MetaData FString
---@param Value FString
---@param Mode EFilterMode
function UPointCloudView:FilterOnMetadata(MetaData, Value, Mode) end
---@param Index int32
---@param Mode EFilterMode
function UPointCloudView:FilterOnIndex(Index, Mode) end
---@param Center FVector
---@param Radius float
---@param Mode EFilterMode
function UPointCloudView:FilterOnBoundingSphere(Center, Radius, Mode) end
---@param BoundingBox FBox
---@param bInvertSelection boolean
---@param Mode EFilterMode
function UPointCloudView:FilterOnBoundingBox(BoundingBox, bInvertSelection, Mode) end
---@param Box FBox
---@return int32
function UPointCloudView:CountResultsInBox(Box) end


---@class USliceAndDiceCommandlet : UCommandlet
local USliceAndDiceCommandlet = {}


---@class USliceAndDiceManagedActors : UObject
---@field Rule TSoftObjectPtr<UPointCloudRule>
---@field ManagedActors TArray<TSoftObjectPtr<AActor>>
---@field RuleRevisionNumber uint64
---@field HashInfo TArray<FSliceAndDiceManagedActorsHashInfo>
---@field Children TArray<USliceAndDiceManagedActors>
---@field ActorEntries TArray<FSliceAndDiceManagedActorsEntry>
local USliceAndDiceManagedActors = {}



---@class USliceAndDiceMapping : UObject
---@field PointCloud TSoftObjectPtr<UPointCloud>
---@field RuleSet TSoftObjectPtr<UPointCloudSliceAndDiceRuleSet>
---@field Root USliceAndDiceManagedActors
---@field bEnabled boolean
local USliceAndDiceMapping = {}

---@param bClearDisabled boolean
function USliceAndDiceMapping:ClearManagedActors(bClearDisabled) end


